﻿using System;

namespace PersonSearch.Plugin.VistA
{
    public class VistaPatientKey
    {
        #region Constructors
        public VistaPatientKey(string vistaId, string siteCode = "")
        {
            if (string.IsNullOrEmpty(vistaId))
                throw new ArgumentNullException(vistaId);

            CheckIfStringIsAnInteger(vistaId);

            VistaId = vistaId;

            SiteCode = siteCode;

            ComposeKey();
        }

        public VistaPatientKey(Guid crmId)
        {
            if (crmId == Guid.Empty)
                throw new ArgumentNullException("crmId");

            CrmId = crmId;

            DeComposeKey();
        }
        #endregion

        #region Private Methods
        private void ComposeKey()
        {
            CrmId = new Guid((SiteCode.PadLeft(3, '0') + "F" + VistaId).PadRight(32, 'F'));
        }

        private void DeComposeKey()
        {
            var siteCode = CrmId.ToString("N").Substring(0, 3);

            CheckIfStringIsAnInteger(siteCode);

            var vistaId = CrmId.ToString("N").TrimEnd(new[] { 'F', 'f' }).Substring(4);

            CheckIfStringIsAnInteger(vistaId);

            VistaId = vistaId;

            SiteCode = siteCode;
        }

        private static void CheckIfStringIsAnInteger(string vistaId)
        {
            int vistapatientid;

            if (!int.TryParse(vistaId, out vistapatientid))
                throw new ApplicationException("Invalid ID: Parsed ID is not an integer");
        }
        #endregion

        #region Public Interface
        public string VistaId { get; private set; }
        public string SiteCode { get; private set; }
        public Guid CrmId { get; private set; }
        #endregion
    }
}